/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.MovieTag;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import java.io.IOException;
import java.util.Arrays;

public final class DoABC
implements MovieTag {
    private static final String FORMAT = "DoABC: { name=%s; deferred=%d; actions=byte<%d> ...}";
    private String name;
    private int deferred;
    private byte[] data;
    private transient int length;

    public DoABC(SWFDecoder coder) throws IOException {
        this.length = coder.readUnsignedShort() & 0x3F;
        if (this.length == 63) {
            this.length = coder.readInt();
        }
        coder.mark();
        this.deferred = coder.readInt();
        this.name = coder.readString();
        this.data = coder.readBytes(new byte[this.length - coder.bytesRead()]);
        coder.check(this.length);
        coder.unmark();
    }

    public DoABC(String scriptName, boolean defer, byte[] script) {
        this.setName(scriptName);
        this.setDeferred(defer);
        this.setData(script);
    }

    public DoABC(DoABC object) {
        this.name = object.name;
        this.deferred = object.deferred;
        this.data = object.data;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aString) {
        if (aString == null || aString.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.name = aString;
    }

    public boolean isDeferred() {
        return (this.deferred & 1) != 0;
    }

    public void setDeferred(boolean defer) {
        this.deferred = defer ? 1 : 0;
    }

    public byte[] getData() {
        return Arrays.copyOf(this.data, this.data.length);
    }

    public void setData(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException();
        }
        this.data = Arrays.copyOf(bytes, bytes.length);
    }

    @Override
    public DoABC copy() {
        return new DoABC(this);
    }

    public String toString() {
        return String.format(FORMAT, this.name, this.deferred, this.data.length);
    }

    @Override
    public int prepareToEncode(Context context) {
        this.length = 4 + context.strlen(this.name) + this.data.length;
        return (this.length > 62 ? 6 : 2) + this.length;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        if (this.length > 62) {
            coder.writeShort(5311);
            coder.writeInt(this.length);
        } else {
            coder.writeShort(0x1480 | this.length);
        }
        coder.mark();
        coder.writeInt(this.deferred);
        coder.writeString(this.name);
        coder.writeBytes(this.data);
        coder.check(this.length);
        coder.unmark();
    }
}

