/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.MovieTag;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.exception.IllegalArgumentRangeException;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class SymbolClass
implements MovieTag {
    private static final String FORMAT = "SymbolClass: { objects=%s}";
    private Map<Integer, String> objects;
    private transient int length;

    public SymbolClass(SWFDecoder coder) throws IOException {
        this.length = coder.readUnsignedShort() & 0x3F;
        if (this.length == 63) {
            this.length = coder.readInt();
        }
        coder.mark();
        int count = coder.readUnsignedShort();
        this.objects = new LinkedHashMap<Integer, String>(count);
        for (int i = 0; i < count; ++i) {
            this.objects.put(coder.readUnsignedShort(), coder.readString());
        }
        coder.check(this.length);
        coder.unmark();
    }

    public SymbolClass() {
        this.objects = new LinkedHashMap<Integer, String>();
    }

    public SymbolClass(Map<Integer, String> map) {
        this.objects = map;
    }

    public SymbolClass(SymbolClass object) {
        this.objects = new LinkedHashMap<Integer, String>(object.objects);
    }

    public SymbolClass add(int uid, String aString) {
        if (uid < 1 || uid > 65535) {
            throw new IllegalArgumentRangeException(1, 65535, uid);
        }
        if (aString == null || aString.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.objects.put(uid, aString);
        return this;
    }

    public Map<Integer, String> getObjects() {
        return this.objects;
    }

    public void setObjects(Map<Integer, String> aTable) {
        if (aTable == null) {
            throw new IllegalArgumentException();
        }
        this.objects = aTable;
    }

    @Override
    public SymbolClass copy() {
        return new SymbolClass(this);
    }

    public String toString() {
        return String.format(FORMAT, this.objects);
    }

    @Override
    public int prepareToEncode(Context context) {
        this.length = 2;
        for (String name : this.objects.values()) {
            this.length += 2 + context.strlen(name);
        }
        return (this.length > 62 ? 6 : 2) + this.length;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        if (this.length > 62) {
            coder.writeShort(4927);
            coder.writeInt(this.length);
        } else {
            coder.writeShort(0x1300 | this.length);
        }
        coder.mark();
        coder.writeShort(this.objects.size());
        for (Integer identifier : this.objects.keySet()) {
            coder.writeShort(identifier);
            coder.writeString(this.objects.get(identifier));
        }
        coder.check(this.length);
        coder.unmark();
    }
}

