/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.action;

import com.flagstone.transform.action.Action;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import java.io.IOException;
import java.util.Arrays;

public final class ActionObject
implements Action {
    private static final String FORMAT = "ActionObject: {type=%d; data=byte[%s] {...} }";
    private final transient int type;
    private final transient byte[] data;

    public ActionObject(int actionType, SWFDecoder coder) throws IOException {
        this.type = actionType;
        this.data = this.type > 127 ? coder.readBytes(new byte[coder.readUnsignedShort()]) : new byte[0];
    }

    public ActionObject(int actionType) {
        this.type = actionType;
        this.data = new byte[0];
    }

    public ActionObject(int actionType, byte[] bytes) {
        this.type = actionType;
        this.data = Arrays.copyOf(bytes, bytes.length);
    }

    public ActionObject(ActionObject object) {
        this.type = object.type;
        this.data = object.data;
    }

    public int getType() {
        return this.type;
    }

    public byte[] getData() {
        return Arrays.copyOf(this.data, this.data.length);
    }

    @Override
    public ActionObject copy() {
        return this;
    }

    public String toString() {
        return String.format(FORMAT, this.type, this.data.length);
    }

    @Override
    public int prepareToEncode(Context context) {
        int length = this.type > 127 ? 3 + this.data.length : 1;
        return length;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        coder.writeByte(this.type);
        if (this.type > 127) {
            coder.writeShort(this.data.length);
            coder.writeBytes(this.data);
        }
    }
}

