/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.action;

import com.flagstone.transform.action.Action;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.coder.SWFFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class With
implements Action {
    private static final String FORMAT = "With: { actions=%s}";
    private final transient List<Action> actions;
    private transient int length;

    public With(SWFDecoder coder, Context context) throws IOException {
        SWFFactory<Action> decoder = context.getRegistry().getActionDecoder();
        coder.readUnsignedShort();
        this.length = coder.readUnsignedShort();
        this.actions = new ArrayList<Action>();
        coder.mark();
        while (coder.bytesRead() < this.length) {
            decoder.getObject(this.actions, coder, context);
        }
        coder.unmark();
    }

    public With(List<Action> list) {
        if (list == null) {
            throw new IllegalArgumentException();
        }
        this.actions = list;
    }

    public With(With object) {
        this.actions = new ArrayList<Action>(object.actions);
    }

    public List<Action> getActions() {
        return new ArrayList<Action>(this.actions);
    }

    @Override
    public With copy() {
        return this;
    }

    public String toString() {
        return String.format(FORMAT, this.actions);
    }

    @Override
    public int prepareToEncode(Context context) {
        this.length = 2;
        for (Action action : this.actions) {
            this.length += action.prepareToEncode(context);
        }
        return 3 + this.length;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        coder.writeByte(148);
        coder.writeShort(2);
        coder.writeShort(this.length - 2);
        for (Action action : this.actions) {
            action.encode(coder, context);
        }
    }
}

