/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.coder;

import com.flagstone.transform.MovieDecoder;
import com.flagstone.transform.MovieTag;
import com.flagstone.transform.action.Action;
import com.flagstone.transform.action.ActionDecoder;
import com.flagstone.transform.coder.Copyable;
import com.flagstone.transform.coder.SWFFactory;
import com.flagstone.transform.fillstyle.FillStyle;
import com.flagstone.transform.fillstyle.FillStyleDecoder;
import com.flagstone.transform.fillstyle.MorphFillStyleDecoder;
import com.flagstone.transform.filter.Filter;
import com.flagstone.transform.filter.FilterDecoder;
import com.flagstone.transform.shape.ShapeDecoder;
import com.flagstone.transform.shape.ShapeRecord;

public final class DecoderRegistry
implements Copyable<DecoderRegistry> {
    private static DecoderRegistry defaultRegistry = new DecoderRegistry();
    private transient SWFFactory<Filter> filterDecoder;
    private transient SWFFactory<FillStyle> fillStyleDecoder;
    private transient SWFFactory<FillStyle> morphStyleDecoder;
    private transient SWFFactory<ShapeRecord> shapeDecoder;
    private transient SWFFactory<Action> actionDecoder;
    private transient SWFFactory<MovieTag> movieDecoder;

    public static DecoderRegistry getDefault() {
        return new DecoderRegistry(defaultRegistry);
    }

    public static void setDefault(DecoderRegistry registry) {
        defaultRegistry = new DecoderRegistry(registry);
    }

    public DecoderRegistry() {
    }

    public DecoderRegistry(DecoderRegistry registry) {
        this.filterDecoder = registry.filterDecoder;
        this.fillStyleDecoder = registry.fillStyleDecoder;
        this.morphStyleDecoder = registry.morphStyleDecoder;
        this.shapeDecoder = registry.shapeDecoder;
        this.actionDecoder = registry.actionDecoder;
        this.movieDecoder = registry.movieDecoder;
    }

    @Override
    public DecoderRegistry copy() {
        return new DecoderRegistry(this);
    }

    public SWFFactory<Filter> getFilterDecoder() {
        return this.filterDecoder;
    }

    public void setFilterDecoder(SWFFactory<Filter> factory) {
        this.filterDecoder = factory;
    }

    public SWFFactory<FillStyle> getFillStyleDecoder() {
        return this.fillStyleDecoder;
    }

    public void setFillStyleDecoder(SWFFactory<FillStyle> factory) {
        this.fillStyleDecoder = factory;
    }

    public SWFFactory<FillStyle> getMorphFillStyleDecoder() {
        return this.morphStyleDecoder;
    }

    public void setMorphFillStyleDecoder(SWFFactory<FillStyle> factory) {
        this.morphStyleDecoder = factory;
    }

    public SWFFactory<ShapeRecord> getShapeDecoder() {
        return this.shapeDecoder;
    }

    public void setShapeDecoder(SWFFactory<ShapeRecord> factory) {
        this.shapeDecoder = factory;
    }

    public SWFFactory<Action> getActionDecoder() {
        return this.actionDecoder;
    }

    public void setActionDecoder(SWFFactory<Action> factory) {
        this.actionDecoder = factory;
    }

    public SWFFactory<MovieTag> getMovieDecoder() {
        return this.movieDecoder;
    }

    public void setMovieDecoder(SWFFactory<MovieTag> factory) {
        this.movieDecoder = factory;
    }

    static {
        defaultRegistry.setFilterDecoder(new FilterDecoder());
        defaultRegistry.setFillStyleDecoder(new FillStyleDecoder());
        defaultRegistry.setMorphFillStyleDecoder(new MorphFillStyleDecoder());
        defaultRegistry.setShapeDecoder(new ShapeDecoder());
        defaultRegistry.setActionDecoder(new ActionDecoder());
        defaultRegistry.setMovieDecoder(new MovieDecoder());
    }
}

