/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.datatype;

import com.flagstone.transform.coder.Coder;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncodeable;
import com.flagstone.transform.coder.SWFEncoder;
import java.io.IOException;

public final class ColorTransform
implements SWFEncodeable {
    private static final int ROUND_TO_BYTES = 7;
    private static final int BITS_TO_BYTES = 3;
    private static final String FORMAT = "ColorTransform: {multiply=[%f, %f, %f, %f]; add=[%d, %d, %d, %d]}";
    private static final int FIELD_SIZE = 4;
    private static final float SCALE_MULTIPLY = 256.0f;
    private static final int DEFAULT_MULTIPLY = 256;
    private static final int DEFAULT_ADD = 0;
    private final transient int multiplyRed;
    private final transient int multiplyGreen;
    private final transient int multiplyBlue;
    private final transient int multiplyAlpha;
    private final transient int addRed;
    private final transient int addGreen;
    private final transient int addBlue;
    private final transient int addAlpha;
    private final transient boolean hasMultiply;
    private final transient boolean hasAdd;
    private transient int size;
    private transient boolean hasAlpha;

    public ColorTransform(SWFDecoder coder, Context context) throws IOException {
        this.hasAlpha = context.contains(3);
        this.hasAdd = coder.readBits(1, false) != 0;
        this.hasMultiply = coder.readBits(1, false) != 0;
        this.size = coder.readBits(4, false);
        if (this.hasMultiply) {
            this.multiplyRed = coder.readBits(this.size, true);
            this.multiplyGreen = coder.readBits(this.size, true);
            this.multiplyBlue = coder.readBits(this.size, true);
            this.multiplyAlpha = this.hasAlpha ? coder.readBits(this.size, true) : 256;
        } else {
            this.multiplyRed = 256;
            this.multiplyGreen = 256;
            this.multiplyBlue = 256;
            this.multiplyAlpha = 256;
        }
        if (this.hasAdd) {
            this.addRed = coder.readBits(this.size, true);
            this.addGreen = coder.readBits(this.size, true);
            this.addBlue = coder.readBits(this.size, true);
            this.addAlpha = this.hasAlpha ? coder.readBits(this.size, true) : 0;
        } else {
            this.addRed = 0;
            this.addGreen = 0;
            this.addBlue = 0;
            this.addAlpha = 0;
        }
        coder.alignToByte();
    }

    public ColorTransform(int rAdd, int gAdd, int bAdd, int aAdd) {
        this.multiplyRed = 256;
        this.multiplyGreen = 256;
        this.multiplyBlue = 256;
        this.multiplyAlpha = 256;
        this.addRed = rAdd;
        this.addGreen = gAdd;
        this.addBlue = bAdd;
        this.addAlpha = aAdd;
        this.hasMultiply = false;
        this.hasAdd = true;
    }

    public ColorTransform(float rMul, float gMul, float bMul, float aMul) {
        this.multiplyRed = (int)(rMul * 256.0f);
        this.multiplyGreen = (int)(gMul * 256.0f);
        this.multiplyBlue = (int)(bMul * 256.0f);
        this.multiplyAlpha = (int)(aMul * 256.0f);
        this.addRed = 0;
        this.addGreen = 0;
        this.addBlue = 0;
        this.addAlpha = 0;
        this.hasMultiply = true;
        this.hasAdd = false;
    }

    public ColorTransform(int rAdd, int gAdd, int bAdd, int aAdd, float rMul, float gMul, float bMul, float aMul) {
        this.addRed = rAdd;
        this.addGreen = gAdd;
        this.addBlue = bAdd;
        this.addAlpha = aAdd;
        this.multiplyRed = (int)(rMul * 256.0f);
        this.multiplyGreen = (int)(gMul * 256.0f);
        this.multiplyBlue = (int)(bMul * 256.0f);
        this.multiplyAlpha = (int)(aMul * 256.0f);
        this.hasMultiply = true;
        this.hasAdd = true;
    }

    public float getMultiplyRed() {
        return (float)this.multiplyRed / 256.0f;
    }

    public float getMultiplyGreen() {
        return (float)this.multiplyGreen / 256.0f;
    }

    public float getMultiplyBlue() {
        return (float)this.multiplyBlue / 256.0f;
    }

    public float getMultiplyAlpha() {
        return (float)this.multiplyAlpha / 256.0f;
    }

    public int getAddRed() {
        return this.addRed;
    }

    public int getAddGreen() {
        return this.addGreen;
    }

    public int getAddBlue() {
        return this.addBlue;
    }

    public int getAddAlpha() {
        return this.addAlpha;
    }

    public String toString() {
        return String.format(FORMAT, Float.valueOf(this.getMultiplyRed()), Float.valueOf(this.getMultiplyGreen()), Float.valueOf(this.getMultiplyBlue()), Float.valueOf(this.getMultiplyAlpha()), this.addRed, this.addGreen, this.addBlue, this.addAlpha);
    }

    public boolean equals(Object object) {
        boolean result;
        if (object == null) {
            result = false;
        } else if (object == this) {
            result = true;
        } else if (object instanceof ColorTransform) {
            ColorTransform transform = (ColorTransform)object;
            result = this.addRed == transform.addRed && this.addGreen == transform.addGreen && this.addBlue == transform.addBlue && this.addAlpha == transform.addAlpha && this.multiplyRed == transform.multiplyRed && this.multiplyGreen == transform.multiplyGreen && this.multiplyBlue == transform.multiplyBlue && this.multiplyAlpha == transform.multiplyAlpha;
        } else {
            result = false;
        }
        return result;
    }

    public int hashCode() {
        return ((((((this.addRed * 31 + this.addGreen) * 31 + this.addBlue) * 31 + this.addAlpha) * 31 + this.multiplyRed) * 31 + this.multiplyGreen) * 31 + this.multiplyBlue) * 31 + this.multiplyAlpha;
    }

    @Override
    public int prepareToEncode(Context context) {
        int numberOfBits = 13;
        this.hasAlpha = context.contains(3);
        this.size = 0;
        int numberOfBytes = this.hasAlpha ? 4 : 3;
        if (this.hasMultiply) {
            this.sizeTerms(this.multiplyRed, this.multiplyGreen, this.multiplyBlue, this.multiplyAlpha);
        }
        if (this.hasAdd) {
            this.sizeTerms(this.addRed, this.addGreen, this.addBlue, this.addAlpha);
        }
        if (this.hasMultiply) {
            numberOfBits += this.size * numberOfBytes;
        }
        if (this.hasAdd) {
            numberOfBits += this.size * numberOfBytes;
        }
        return numberOfBits >> 3;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        coder.writeBits(this.hasAdd ? 1 : 0, 1);
        coder.writeBits(this.hasMultiply ? 1 : 0, 1);
        coder.writeBits(this.size, 4);
        if (this.hasMultiply) {
            this.encodeTerms(this.multiplyRed, this.multiplyGreen, this.multiplyBlue, this.multiplyAlpha, coder);
        }
        if (this.hasAdd) {
            this.encodeTerms(this.addRed, this.addGreen, this.addBlue, this.addAlpha, coder);
        }
        coder.alignToByte();
    }

    private void sizeTerms(int red, int green, int blue, int alpha) {
        this.size = Math.max(this.size, Coder.size(red));
        this.size = Math.max(this.size, Coder.size(green));
        this.size = Math.max(this.size, Coder.size(blue));
        if (this.hasAlpha) {
            this.size = Math.max(this.size, Coder.size(alpha));
        }
    }

    private void encodeTerms(int red, int green, int blue, int alpha, SWFEncoder coder) throws IOException {
        coder.writeBits(red, this.size);
        coder.writeBits(green, this.size);
        coder.writeBits(blue, this.size);
        if (this.hasAlpha) {
            coder.writeBits(alpha, this.size);
        }
    }
}

