/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.fillstyle;

import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.Copyable;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncodeable;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.fillstyle.Gradient;
import java.io.IOException;

public final class MorphGradient
implements SWFEncodeable,
Copyable<MorphGradient> {
    private static final String FORMAT = "MorphGradient: { start=%s; end=%s}";
    private Gradient start;
    private Gradient end;

    public MorphGradient(SWFDecoder coder, Context context) throws IOException {
        this.start = new Gradient(coder, context);
        this.end = new Gradient(coder, context);
    }

    public MorphGradient(Gradient startGradient, Gradient endGradient) {
        this.setStart(startGradient);
        this.setEnd(endGradient);
    }

    public MorphGradient(MorphGradient object) {
        this.start = object.start;
        this.end = object.end;
    }

    public Gradient getStart() {
        return this.start;
    }

    public Gradient getEnd() {
        return this.end;
    }

    public void setStart(Gradient gradient) {
        if (gradient == null) {
            throw new IllegalArgumentException();
        }
        this.start = gradient;
    }

    public void setEnd(Gradient gradient) {
        if (gradient == null) {
            throw new IllegalArgumentException();
        }
        this.end = gradient;
    }

    @Override
    public MorphGradient copy() {
        return new MorphGradient(this);
    }

    public String toString() {
        return String.format(FORMAT, this.start.toString(), this.end.toString());
    }

    @Override
    public int prepareToEncode(Context context) {
        int length = this.start.prepareToEncode(context);
        return length += this.end.prepareToEncode(context);
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        this.start.encode(coder, context);
        this.end.encode(coder, context);
    }
}

