/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.linestyle;

import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.coder.SWFFactory;
import com.flagstone.transform.datatype.Color;
import com.flagstone.transform.exception.IllegalArgumentRangeException;
import com.flagstone.transform.fillstyle.FillStyle;
import com.flagstone.transform.linestyle.CapStyle;
import com.flagstone.transform.linestyle.JoinStyle;
import com.flagstone.transform.linestyle.LineStyle;
import java.io.IOException;
import java.util.ArrayList;

public final class MorphLineStyle2
implements LineStyle {
    private static final String FORMAT = "MorphLineStyle2: { startWidth=%d; endWidth=%d; startColor=%s; endColor=%s; fillStyle=%s; startCap=%s; endCap=%s; joinStyle=%s; scaledHorizontally=%b; scaledVertically=%b; pixelAligned=%b; lineClosed=%b; miterLimit=%d}";
    private int startWidth;
    private int endWidth;
    private Color startColor;
    private Color endColor;
    private int startCap;
    private int endCap;
    private int joinStyle;
    private FillStyle fillStyle;
    private boolean horizontal;
    private boolean vertical;
    private boolean pixelAligned;
    private boolean lineClosed;
    private int miterLimit;
    private transient boolean hasFillStyle;
    private transient boolean hasMiter;

    public MorphLineStyle2(SWFDecoder coder, Context context) throws IOException {
        this.startWidth = coder.readUnsignedShort();
        this.endWidth = coder.readUnsignedShort();
        int bits = coder.readByte();
        this.startCap = (bits & 0x40) > 0 ? 1 : ((bits & 0x80) > 0 ? 2 : 0);
        if ((bits & 0x10) > 0) {
            this.joinStyle = 1;
            this.hasMiter = false;
        } else if ((bits & 0x20) > 0) {
            this.joinStyle = 2;
            this.hasMiter = true;
        } else {
            this.joinStyle = 0;
            this.hasMiter = false;
        }
        this.hasFillStyle = (bits & 8) != 0;
        this.horizontal = (bits & 4) == 0;
        this.vertical = (bits & 2) == 0;
        this.pixelAligned = (bits & 1) != 0;
        bits = coder.readByte();
        this.lineClosed = (bits & 4) == 0;
        this.endCap = bits & 3;
        if (this.hasMiter) {
            coder.readUnsignedShort();
        }
        if (this.hasFillStyle) {
            SWFFactory<FillStyle> decoder = context.getRegistry().getMorphFillStyleDecoder();
            ArrayList styles = new ArrayList();
            decoder.getObject(styles, coder, context);
            this.fillStyle = (FillStyle)styles.get(0);
        } else {
            this.startColor = new Color(coder, context);
            this.endColor = new Color(coder, context);
        }
    }

    public MorphLineStyle2(int initialWidth, int finalWidth, Color initialColor, Color finalColor) {
        this.setStartWidth(initialWidth);
        this.setEndWidth(finalWidth);
        this.setStartColor(initialColor);
        this.setEndColor(finalColor);
        this.vertical = true;
        this.vertical = true;
        this.lineClosed = true;
    }

    public MorphLineStyle2(int initialWidth, int finalWidth, FillStyle style) {
        this.setStartWidth(initialWidth);
        this.setEndWidth(finalWidth);
        this.setFillStyle(style);
        this.vertical = true;
        this.vertical = true;
        this.lineClosed = true;
    }

    public MorphLineStyle2(MorphLineStyle2 object) {
        this.startWidth = object.startWidth;
        this.endWidth = object.endWidth;
        this.startColor = object.startColor;
        this.endColor = object.endColor;
        if (object.fillStyle != null) {
            this.fillStyle = (FillStyle)object.fillStyle.copy();
        }
        this.startCap = object.startCap;
        this.endCap = object.endCap;
        this.joinStyle = object.joinStyle;
        this.horizontal = object.horizontal;
        this.vertical = object.vertical;
        this.pixelAligned = object.pixelAligned;
        this.lineClosed = object.lineClosed;
        this.miterLimit = object.miterLimit;
    }

    public int getStartWidth() {
        return this.startWidth;
    }

    public int getEndWidth() {
        return this.endWidth;
    }

    public Color getStartColor() {
        return this.startColor;
    }

    public Color getEndColor() {
        return this.endColor;
    }

    public void setStartWidth(int aNumber) {
        if (aNumber < 0 || aNumber > 65535) {
            throw new IllegalArgumentRangeException(0, 65535, aNumber);
        }
        this.startWidth = aNumber;
    }

    public void setEndWidth(int aNumber) {
        if (aNumber < 0 || aNumber > 65535) {
            throw new IllegalArgumentRangeException(0, 65535, aNumber);
        }
        this.endWidth = aNumber;
    }

    public void setStartColor(Color aColor) {
        if (aColor == null) {
            throw new IllegalArgumentException();
        }
        this.startColor = aColor;
    }

    public void setEndColor(Color aColor) {
        if (aColor == null) {
            throw new IllegalArgumentException();
        }
        this.endColor = aColor;
    }

    public CapStyle getStartCap() {
        CapStyle style = this.startCap == 1 ? CapStyle.NONE : (this.startCap == 2 ? CapStyle.SQUARE : CapStyle.ROUND);
        return style;
    }

    public void setStartCap(CapStyle style) {
        switch (style) {
            case NONE: {
                this.startCap = 1;
                break;
            }
            case SQUARE: {
                this.startCap = 2;
                break;
            }
            default: {
                this.startCap = 0;
            }
        }
    }

    public CapStyle getEndCap() {
        CapStyle style = this.endCap == 1 ? CapStyle.NONE : (this.endCap == 2 ? CapStyle.SQUARE : CapStyle.ROUND);
        return style;
    }

    public void setEndCap(CapStyle style) {
        switch (style) {
            case NONE: {
                this.endCap = 1;
                break;
            }
            case SQUARE: {
                this.endCap = 2;
                break;
            }
            default: {
                this.endCap = 0;
            }
        }
    }

    public JoinStyle getJoinStyle() {
        JoinStyle style = this.endCap == 1 ? JoinStyle.BEVEL : (this.endCap == 2 ? JoinStyle.MITER : JoinStyle.ROUND);
        return style;
    }

    public void setJoinStyle(JoinStyle style) {
        switch (style) {
            case BEVEL: {
                this.joinStyle = 1;
                break;
            }
            case MITER: {
                this.joinStyle = 2;
                break;
            }
            default: {
                this.joinStyle = 0;
            }
        }
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    public void setHorizontal(boolean scale) {
        this.horizontal = scale;
    }

    public boolean isVertical() {
        return this.vertical;
    }

    public void setVertical(boolean scale) {
        this.vertical = scale;
    }

    public boolean isPixelAligned() {
        return this.pixelAligned;
    }

    public void setPixelAligned(boolean align) {
        this.pixelAligned = align;
    }

    public boolean isLineClosed() {
        return this.lineClosed;
    }

    public void setLineClosed(boolean close) {
        this.lineClosed = close;
    }

    public int getMiterLimit() {
        return this.miterLimit;
    }

    public void setMiterLimit(int limit) {
        if (limit < 0 || limit > 65535) {
            throw new IllegalArgumentRangeException(0, 65535, limit);
        }
        this.miterLimit = limit;
    }

    public FillStyle getFillStyle() {
        return this.fillStyle;
    }

    public void setFillStyle(FillStyle style) {
        this.fillStyle = style;
    }

    @Override
    public MorphLineStyle2 copy() {
        return new MorphLineStyle2(this);
    }

    public String toString() {
        return String.format(FORMAT, this.startWidth, this.endWidth, this.startColor, this.endColor, this.fillStyle, this.startCap, this.endCap, this.joinStyle, this.horizontal, this.vertical, this.pixelAligned, this.lineClosed, this.miterLimit);
    }

    @Override
    public int prepareToEncode(Context context) {
        this.hasFillStyle = this.fillStyle != null;
        this.hasMiter = this.joinStyle == 2;
        int length = 6;
        if (this.hasMiter) {
            length += 2;
        }
        if (this.hasFillStyle) {
            length += this.fillStyle.prepareToEncode(context);
        } else {
            length += 4;
            length += 4;
        }
        if (this.horizontal || this.vertical) {
            context.put(10, 1);
        }
        return length;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        coder.writeShort(this.startWidth);
        coder.writeShort(this.endWidth);
        int value = 0;
        if (this.startCap == 1) {
            value |= 0x40;
        } else if (this.startCap == 2) {
            value |= 0x80;
        }
        if (this.joinStyle == 1) {
            value |= 0x10;
        } else if (this.joinStyle == 2) {
            value |= 0x20;
        }
        value |= this.fillStyle == null ? 0 : 8;
        value |= this.horizontal ? 0 : 4;
        value |= this.vertical ? 0 : 2;
        coder.writeByte(value |= this.pixelAligned ? 1 : 0);
        value = this.lineClosed ? 0 : 4;
        coder.writeByte(value |= this.endCap);
        if (this.hasMiter) {
            coder.writeShort(this.miterLimit);
        }
        if (this.hasFillStyle) {
            this.fillStyle.encode(coder, context);
        } else {
            this.startColor.encode(coder, context);
            this.endColor.encode(coder, context);
        }
    }
}

