/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.sound;

import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.Copyable;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncodeable;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.exception.IllegalArgumentRangeException;
import com.flagstone.transform.sound.Envelope;
import java.io.IOException;

public final class SoundInfo
implements SWFEncodeable,
Copyable<SoundInfo> {
    private static final String FORMAT = "SoundInfo: { identifier=%d; mode=%s; inPoint=%d; outPoint=%d; loopCount=%d; envelopes=%s}";
    private int identifier;
    private int mode;
    private Integer inPoint;
    private Integer outPoint;
    private Integer loopCount;
    private Envelope envelope;

    public SoundInfo(int uid, SWFDecoder coder) throws IOException {
        this.identifier = uid;
        int info = coder.readByte();
        this.mode = info & 0xF0;
        if ((info & 1) != 0) {
            this.inPoint = coder.readInt();
        }
        if ((info & 2) != 0) {
            this.outPoint = coder.readInt();
        }
        if ((info & 4) != 0) {
            this.loopCount = coder.readUnsignedShort();
        }
        if ((info & 8) != 0) {
            this.envelope = new Envelope(coder);
        }
    }

    public SoundInfo(int uid, Mode aMode, int aCount, Envelope anEnvelope) {
        this.setIdentifier(uid);
        this.setMode(aMode);
        this.setLoopCount(aCount);
        this.setEnvelope(anEnvelope);
    }

    public SoundInfo(SoundInfo object) {
        this.identifier = object.identifier;
        this.mode = object.mode;
        this.loopCount = object.loopCount;
        this.inPoint = object.inPoint;
        this.outPoint = object.outPoint;
        if (object.envelope != null) {
            this.envelope = object.envelope.copy();
        }
    }

    public int getIdentifier() {
        return this.identifier;
    }

    public Mode getMode() {
        Mode value;
        switch (this.mode) {
            case 0: {
                value = Mode.START;
                break;
            }
            case 16: {
                value = Mode.CONTINUE;
                break;
            }
            case 32: {
                value = Mode.STOP;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return value;
    }

    public Integer getInPoint() {
        return this.inPoint;
    }

    public Integer getOutPoint() {
        return this.outPoint;
    }

    public Integer getLoopCount() {
        return this.loopCount;
    }

    public Envelope getEnvelope() {
        return this.envelope;
    }

    public void setIdentifier(int uid) {
        if (uid < 1 || uid > 65535) {
            throw new IllegalArgumentRangeException(1, 65535, uid);
        }
        this.identifier = uid;
    }

    public void setMode(Mode soundMode) {
        switch (soundMode) {
            case START: {
                this.mode = 0;
                break;
            }
            case CONTINUE: {
                this.mode = 16;
                break;
            }
            case STOP: {
                this.mode = 32;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void setInPoint(Integer aNumber) {
        if (aNumber != null && (aNumber < 0 || aNumber > 65535)) {
            throw new IllegalArgumentRangeException(0, 65535, aNumber);
        }
        this.inPoint = aNumber;
    }

    public void setOutPoint(Integer aNumber) {
        if (aNumber != null && (aNumber < 0 || aNumber > 65535)) {
            throw new IllegalArgumentRangeException(0, 65535, aNumber);
        }
        this.outPoint = aNumber;
    }

    public void setLoopCount(Integer aNumber) {
        if (aNumber != null && (aNumber < 0 || aNumber > 65535)) {
            throw new IllegalArgumentRangeException(0, 65535, aNumber);
        }
        this.loopCount = aNumber;
    }

    public void setEnvelope(Envelope anEnvelope) {
        this.envelope = anEnvelope;
    }

    @Override
    public SoundInfo copy() {
        return new SoundInfo(this);
    }

    public String toString() {
        return String.format(FORMAT, this.identifier, this.mode, this.inPoint, this.outPoint, this.loopCount, this.envelope);
    }

    @Override
    public int prepareToEncode(Context context) {
        int length = 3;
        if (this.inPoint != null) {
            length += 4;
        }
        if (this.outPoint != null) {
            length += 4;
        }
        if (this.loopCount != null) {
            length += 2;
        }
        if (this.envelope != null) {
            length += this.envelope.prepareToEncode(context);
        }
        return length;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        coder.writeShort(this.identifier);
        int bits = this.mode;
        bits |= this.envelope == null ? 0 : 8;
        bits |= this.loopCount == null ? 0 : 4;
        bits |= this.outPoint == null ? 0 : 2;
        coder.writeByte(bits |= this.inPoint == null ? 0 : 1);
        if (this.inPoint != null) {
            coder.writeInt(this.inPoint);
        }
        if (this.outPoint != null) {
            coder.writeInt(this.outPoint);
        }
        if (this.loopCount != null) {
            coder.writeShort(this.loopCount);
        }
        if (this.envelope != null) {
            this.envelope.encode(coder, context);
        }
    }

    public static enum Mode {
        START,
        CONTINUE,
        STOP;

    }
}

