/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.util.font;

import com.flagstone.transform.util.font.Font;
import com.flagstone.transform.util.font.FontDecoder;
import com.flagstone.transform.util.font.FontRegistry;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.zip.DataFormatException;

public final class FontFactory {
    private transient FontDecoder decoder;

    public void read(File file) throws IOException, DataFormatException {
        String fontType;
        if (file.getName().endsWith("ttf")) {
            fontType = "ttf";
        } else if (file.getName().endsWith("swf")) {
            fontType = "swf";
        } else {
            throw new DataFormatException("Unsupported format");
        }
        this.decoder = FontRegistry.getFontProvider(fontType);
        this.decoder.read(file);
    }

    public void read(URL url) throws IOException, DataFormatException {
        URLConnection connection = url.openConnection();
        int fileSize = connection.getContentLength();
        if (fileSize < 0) {
            throw new FileNotFoundException(url.getFile());
        }
        String mimeType = connection.getContentType();
        this.decoder = FontRegistry.getFontProvider(mimeType);
        if (this.decoder == null) {
            throw new DataFormatException("Unsupported format");
        }
        this.decoder.read(url);
    }

    public List<Font> getFonts() {
        return this.decoder.getFonts();
    }
}

