/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.util.image;

import com.flagstone.transform.util.image.ImageEncoding;
import java.io.DataInput;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Vector;

public final class ImageInfo {
    public static final int FORMAT_JPEG = 0;
    public static final int FORMAT_GIF = 1;
    public static final int FORMAT_PNG = 2;
    public static final int FORMAT_BMP = 3;
    public static final int FORMAT_PCX = 4;
    public static final int FORMAT_IFF = 5;
    public static final int FORMAT_RAS = 6;
    public static final int FORMAT_PBM = 7;
    public static final int FORMAT_PGM = 8;
    public static final int FORMAT_PPM = 9;
    public static final int FORMAT_PSD = 10;
    private static final String[] FORMAT_NAMES = new String[]{"JPEG", "GIF", "PNG", "BMP", "PCX", "IFF", "RAS", "PBM", "PGM", "PPM", "PSD"};
    private static final String[] MIME_TYPE_STRINGS = new String[]{"image/jpeg", "image/gif", "image/png", "image/bmp", "image/pcx", "image/iff", "image/ras", "image/x-portable-bitmap", "image/x-portable-graymap", "image/x-portable-pixmap", "image/psd"};
    private ImageEncoding imageFormat;
    private int width;
    private int height;
    private int bitsPerPixel;
    private boolean progressive;
    private int format;
    private InputStream in;
    private DataInput din;
    private boolean collectComments = true;
    private Vector<String> comments;
    private int numberOfImages;
    private int physicalHeightDpi;
    private int physicalWidthDpi;

    private void addComment(String s) {
        if (this.comments == null) {
            this.comments = new Vector();
        }
        this.comments.addElement(s);
    }

    public boolean check() {
        this.format = -1;
        this.width = -1;
        this.height = -1;
        this.bitsPerPixel = -1;
        this.numberOfImages = 1;
        this.physicalHeightDpi = -1;
        this.physicalWidthDpi = -1;
        this.comments = null;
        try {
            int b1 = this.read() & 0xFF;
            int b2 = this.read() & 0xFF;
            if (b1 == 71 && b2 == 73) {
                return false;
            }
            if (b1 == 137 && b2 == 80) {
                return this.checkPng();
            }
            if (b1 == 255 && b2 == 216) {
                return this.checkJpeg();
            }
            if (b1 == 66 && b2 == 77) {
                return this.checkBmp();
            }
            return false;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    private boolean checkBmp() throws IOException {
        int y;
        byte[] a = new byte[44];
        if (this.read(a) != a.length) {
            return false;
        }
        this.width = ImageInfo.getIntLittleEndian(a, 16);
        this.height = ImageInfo.getIntLittleEndian(a, 20);
        if (this.width < 1 || this.height < 1) {
            return false;
        }
        this.bitsPerPixel = ImageInfo.getShortLittleEndian(a, 26);
        if (this.bitsPerPixel != 1 && this.bitsPerPixel != 4 && this.bitsPerPixel != 8 && this.bitsPerPixel != 16 && this.bitsPerPixel != 24 && this.bitsPerPixel != 32) {
            return false;
        }
        int x = (int)((double)ImageInfo.getIntLittleEndian(a, 36) * 0.0254);
        if (x > 0) {
            this.setPhysicalWidthDpi(x);
        }
        if ((y = (int)((double)ImageInfo.getIntLittleEndian(a, 40) * 0.0254)) > 0) {
            this.setPhysicalHeightDpi(y);
        }
        this.format = 3;
        this.imageFormat = ImageEncoding.BMP;
        return true;
    }

    private boolean checkJpeg() throws IOException {
        byte[] data = new byte[12];
        while (this.read(data, 0, 4) == 4) {
            int marker = ImageInfo.getShortBigEndian(data, 0);
            int size = ImageInfo.getShortBigEndian(data, 2);
            if ((marker & 0xFF00) != 65280) {
                return false;
            }
            if (marker == 65504) {
                if (size < 14) {
                    this.skip(size - 2);
                    continue;
                }
                if (this.read(data, 0, 12) != 12) {
                    return false;
                }
                byte[] appoId = new byte[]{74, 70, 73, 70, 0};
                if (ImageInfo.equals(appoId, 0, data, 0, 5)) {
                    if (data[7] == 1) {
                        this.setPhysicalWidthDpi(ImageInfo.getShortBigEndian(data, 8));
                        this.setPhysicalHeightDpi(ImageInfo.getShortBigEndian(data, 10));
                    } else if (data[7] == 2) {
                        int x = ImageInfo.getShortBigEndian(data, 8);
                        int y = ImageInfo.getShortBigEndian(data, 10);
                        this.setPhysicalWidthDpi((int)((float)x * 2.54f));
                        this.setPhysicalHeightDpi((int)((float)y * 2.54f));
                    }
                }
                this.skip(size - 14);
                continue;
            }
            if (this.collectComments && size > 2 && marker == 65534) {
                byte[] chars = new byte[size -= 2];
                if (this.read(chars, 0, size) != size) {
                    return false;
                }
                String comment = new String(chars, "iso-8859-1");
                comment = comment.trim();
                this.addComment(comment);
                continue;
            }
            if (marker >= 65472 && marker <= 65487 && marker != 65476 && marker != 65480) {
                if (this.read(data, 0, 6) != 6) {
                    return false;
                }
                this.format = 0;
                this.imageFormat = ImageEncoding.JPEG;
                this.bitsPerPixel = (data[0] & 0xFF) * (data[5] & 0xFF);
                this.progressive = marker == 65474 || marker == 65478 || marker == 65482 || marker == 65486;
                this.width = ImageInfo.getShortBigEndian(data, 3);
                this.height = ImageInfo.getShortBigEndian(data, 1);
                return true;
            }
            this.skip(size - 2);
        }
        return false;
    }

    private boolean checkPng() throws IOException {
        byte[] pngmagic = new byte[]{78, 71, 13, 10, 26, 10};
        byte[] a = new byte[27];
        if (this.read(a) != 27) {
            return false;
        }
        if (!ImageInfo.equals(a, 0, pngmagic, 0, 6)) {
            return false;
        }
        this.format = 2;
        this.imageFormat = ImageEncoding.PNG;
        this.width = ImageInfo.getIntBigEndian(a, 14);
        this.height = ImageInfo.getIntBigEndian(a, 18);
        this.bitsPerPixel = a[22] & 0xFF;
        int colorType = a[23] & 0xFF;
        if (colorType == 2 || colorType == 6) {
            this.bitsPerPixel *= 3;
        }
        this.progressive = (a[26] & 0xFF) != 0;
        return true;
    }

    private static boolean determineVerbosity(String[] args) {
        if (args != null && args.length > 0) {
            for (String arg : args) {
                if (!"-c".equals(arg)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean equals(byte[] a1, int offs1, byte[] a2, int offs2, int num) {
        int index1 = offs1;
        int index2 = offs2;
        int count = num;
        while (count-- > 0) {
            if (a1[index1++] == a2[index2++]) continue;
            return false;
        }
        return true;
    }

    public int getBitsPerPixel() {
        return this.bitsPerPixel;
    }

    public String getComment(int index) {
        if (this.comments == null || index < 0 || index >= this.comments.size()) {
            throw new IllegalArgumentException("Not a valid comment index: " + index);
        }
        return this.comments.elementAt(index);
    }

    public int getFormat() {
        return this.format;
    }

    public ImageEncoding getImageFormat() {
        return this.imageFormat;
    }

    public String getFormatName() {
        if (this.format >= 0 && this.format < FORMAT_NAMES.length) {
            return FORMAT_NAMES[this.format];
        }
        return "?";
    }

    public int getHeight() {
        return this.height;
    }

    private static int getIntBigEndian(byte[] a, int offs) {
        return (a[offs] & 0xFF) << 24 | (a[offs + 1] & 0xFF) << 16 | (a[offs + 2] & 0xFF) << 8 | a[offs + 3] & 0xFF;
    }

    private static int getIntLittleEndian(byte[] a, int offs) {
        return (a[offs + 3] & 0xFF) << 24 | (a[offs + 2] & 0xFF) << 16 | (a[offs + 1] & 0xFF) << 8 | a[offs] & 0xFF;
    }

    public String getMimeType() {
        if (this.format >= 0 && this.format < MIME_TYPE_STRINGS.length) {
            if (this.format == 0 && this.progressive) {
                return "image/pjpeg";
            }
            return MIME_TYPE_STRINGS[this.format];
        }
        return null;
    }

    public int getNumberOfComments() {
        if (this.comments == null) {
            return 0;
        }
        return this.comments.size();
    }

    public int getNumberOfImages() {
        return this.numberOfImages;
    }

    public int getPhysicalHeightDpi() {
        return this.physicalHeightDpi;
    }

    public float getPhysicalHeightInch() {
        int h = this.getHeight();
        int ph = this.getPhysicalHeightDpi();
        if (h > 0 && ph > 0) {
            return (float)h / (float)ph;
        }
        return -1.0f;
    }

    public int getPhysicalWidthDpi() {
        return this.physicalWidthDpi;
    }

    public float getPhysicalWidthInch() {
        int w = this.getWidth();
        int pw = this.getPhysicalWidthDpi();
        if (w > 0 && pw > 0) {
            return (float)w / (float)pw;
        }
        return -1.0f;
    }

    private static int getShortBigEndian(byte[] a, int offs) {
        return (a[offs] & 0xFF) << 8 | a[offs + 1] & 0xFF;
    }

    private static int getShortLittleEndian(byte[] a, int offs) {
        return a[offs] & 0xFF | (a[offs + 1] & 0xFF) << 8;
    }

    public int getWidth() {
        return this.width;
    }

    public boolean isProgressive() {
        return this.progressive;
    }

    public static void main(String[] args) {
        ImageInfo imageInfo = new ImageInfo();
        boolean verbose = ImageInfo.determineVerbosity(args);
        if (args.length == 0) {
            ImageInfo.run(null, System.in, imageInfo, verbose);
        } else {
            int index = 0;
            while (index < args.length) {
                InputStream in = null;
                try {
                    String name = args[index++];
                    in = name.startsWith("http://") ? new URL(name).openConnection().getInputStream() : new FileInputStream(name);
                    ImageInfo.run(name, in, imageInfo, verbose);
                    in.close();
                }
                catch (IOException e) {
                    try {
                        if (in == null) continue;
                        in.close();
                    }
                    catch (IOException ee) {
                        ee.printStackTrace();
                    }
                }
            }
        }
    }

    private int read() throws IOException {
        if (this.in != null) {
            return this.in.read();
        }
        return this.din.readByte();
    }

    private int read(byte[] a) throws IOException {
        if (this.in != null) {
            return this.in.read(a);
        }
        this.din.readFully(a);
        return a.length;
    }

    private int read(byte[] a, int offset, int num) throws IOException {
        if (this.in != null) {
            return this.in.read(a, offset, num);
        }
        this.din.readFully(a, offset, num);
        return num;
    }

    private static void run(String sourceName, InputStream in, ImageInfo imageInfo, boolean verbose) {
        imageInfo.setInput(in);
        imageInfo.setCollectComments(verbose);
    }

    public void setCollectComments(boolean newValue) {
        this.collectComments = newValue;
    }

    public void setInput(DataInput dataInput) {
        this.din = dataInput;
        this.in = null;
    }

    public void setInput(InputStream inputStream) {
        this.in = inputStream;
        this.din = null;
    }

    private void setPhysicalHeightDpi(int newValue) {
        this.physicalWidthDpi = newValue;
    }

    private void setPhysicalWidthDpi(int newValue) {
        this.physicalHeightDpi = newValue;
    }

    private void skip(int num) throws IOException {
        int count = num;
        while (count > 0) {
            long result = this.in != null ? this.in.skip(num) : (long)this.din.skipBytes(num);
            if (result > 0L) {
                count = (int)((long)count - result);
                continue;
            }
            result = this.in != null ? (long)this.in.read() : (long)this.din.readByte();
            if (result == -1L) {
                throw new IOException("Premature end of input.");
            }
            --count;
        }
    }
}

