/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.util.sound;

import com.flagstone.transform.MovieTag;
import com.flagstone.transform.coder.LittleDecoder;
import com.flagstone.transform.sound.DefineSound;
import com.flagstone.transform.sound.SoundFormat;
import com.flagstone.transform.sound.SoundStreamBlock;
import com.flagstone.transform.sound.SoundStreamHead2;
import com.flagstone.transform.util.sound.SoundDecoder;
import com.flagstone.transform.util.sound.SoundProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.DataFormatException;

public final class WAVDecoder
implements SoundProvider,
SoundDecoder {
    private static final int[] RIFF = new int[]{82, 73, 70, 70};
    private static final int[] WAV = new int[]{87, 65, 86, 69};
    private static final int FMT = 544501094;
    private static final int DATA = 1635017060;
    private transient SoundFormat format;
    private transient int numberOfChannels;
    private transient int samplesPerChannel;
    private transient int sampleRate;
    private transient int sampleSize;
    private transient byte[] sound = null;
    private transient float movieRate;
    private transient int bytesSent;

    @Override
    public SoundDecoder newDecoder() {
        return new WAVDecoder();
    }

    @Override
    public void read(File file) throws IOException, DataFormatException {
        this.read(new FileInputStream(file));
    }

    @Override
    public void read(URL url) throws IOException, DataFormatException {
        URLConnection connection = url.openConnection();
        int fileSize = connection.getContentLength();
        if (fileSize < 0) {
            throw new FileNotFoundException(url.getFile());
        }
        this.read(url.openStream());
    }

    @Override
    public DefineSound defineSound(int identifier) {
        return new DefineSound(identifier, this.format, this.sampleRate, this.numberOfChannels, this.sampleSize, this.samplesPerChannel, this.sound);
    }

    @Override
    public DefineSound defineSound(int identifier, float duration) {
        return new DefineSound(identifier, this.format, this.sampleRate, this.numberOfChannels, this.sampleSize, this.samplesPerChannel, this.sound);
    }

    @Override
    public MovieTag streamHeader(float frameRate) {
        this.movieRate = frameRate;
        return new SoundStreamHead2(this.format, this.sampleRate, this.numberOfChannels, this.sampleSize, this.sampleRate, this.numberOfChannels, this.sampleSize, (int)((float)this.sampleRate / frameRate));
    }

    @Override
    public MovieTag streamSound() {
        int samplesPerBlock = (int)((float)this.sampleRate / this.movieRate);
        int bytesPerBlock = samplesPerBlock * this.sampleSize * this.numberOfChannels;
        SoundStreamBlock block = null;
        if (this.bytesSent < this.sound.length) {
            int bytesRemaining = this.sound.length - this.bytesSent;
            int numberOfBytes = bytesRemaining < bytesPerBlock ? bytesRemaining : bytesPerBlock;
            byte[] bytes = new byte[numberOfBytes];
            System.arraycopy(this.sound, this.bytesSent, bytes, 0, numberOfBytes);
            block = new SoundStreamBlock(bytes);
            this.bytesSent += numberOfBytes;
        }
        return block;
    }

    @Override
    public void read(InputStream stream) throws IOException, DataFormatException {
        int i;
        LittleDecoder coder = new LittleDecoder(stream);
        for (i = 0; i < RIFF.length; ++i) {
            if (coder.readByte() == RIFF[i]) continue;
            throw new DataFormatException("Unsupported format");
        }
        coder.readInt();
        for (i = 0; i < WAV.length; ++i) {
            if (coder.readByte() == WAV[i]) continue;
            throw new DataFormatException("Unsupported format");
        }
        boolean readFMT = false;
        boolean readDATA = false;
        do {
            int chunkType = coder.readInt();
            int length = coder.readInt();
            switch (chunkType) {
                case 544501094: {
                    this.decodeFMT(coder);
                    readFMT = true;
                    break;
                }
                case 1635017060: {
                    this.decodeDATA(coder, length);
                    readDATA = true;
                    break;
                }
                default: {
                    coder.skip(length);
                }
            }
        } while (!readFMT || !readDATA);
    }

    private void decodeFMT(LittleDecoder coder) throws IOException, DataFormatException {
        this.format = SoundFormat.PCM;
        if (coder.readUnsignedShort() != 1) {
            throw new DataFormatException("Unsupported format");
        }
        this.numberOfChannels = coder.readUnsignedShort();
        this.sampleRate = coder.readInt();
        coder.readInt();
        coder.readUnsignedShort();
        this.sampleSize = coder.readUnsignedShort() >> 3;
    }

    private void decodeDATA(LittleDecoder coder, int length) throws IOException {
        this.samplesPerChannel = length / (this.sampleSize * this.numberOfChannels);
        this.sound = coder.readBytes(new byte[length]);
    }
}

